function [m_beta]=Binding_2FHeston_MA_noise(par,coeffs,M,T,nrepl,W);

% Purpose: Compute mean(beta_S) for the OU  model with noise

% input: par: structural parameters (4x1) vector
%        coeffs: auxiliary estimates (4x1) vector 
%        M: number of intradaily steps
%        T: number of days
%        nrepl: number of II replications
%        invVCV: weigthing matrix
%        W : matrix of innovations (Tx2xH)
% output: d: distance

beta=zeros(size(coeffs,1),nrepl);  % preallocate beta_S
P0=100;  % price at t=0 

%% Parameters 
kappa_1=(par(1)); % TFSV model speed of mean reversion 1
kappa_2=(par(2)); % TFSV model speed of mean reversion 2
omega=(par(3));   % mean of SV
eta_1=(par(4));   % TFSV model vol-of-vol 1
eta_2=(par(5));   % TFSV model vol-of-vol 2
sigma_nu=par(6); % variance of the noise
phi=par(7); % MA(1) noise parameter

params=[kappa_1,kappa_2,omega,eta_1,eta_2,phi]; % parameters of the 
sampling=12*5; % 5 minutes sub-sampling

for j=1:nrepl
    w=W(:,:,j); % innovations
    [r]=simulate_heston_two_factors(T,M,params,1,w(:,1),w(:,2),w(:,3),w(:,4)); % generate (percentage) log-returns
    u=w(:,5)*sqrt(sigma_nu); % innovation of MA(1) noise
    noise=[0;phi*u(1:end-1)+u(2:end)]; % MA(1) noise
    nu=reshape(noise,M,T);   % nu is the reshaped vector of noise
    r_n=r+nu;  % add the noise to the log-return at the 5-second frequency
    RV_5_sec=sum(r_n.^2)'; % construct RV at 5 seconds
    p=log(P0)+cumsum(reshape(r/100,M*T,1)); % generate log-prices
    p_D=reshape(p(1:sampling:end),M/sampling,T); % subsampling of log-prices
    r_D=reshape([zeros(1,T);diff(p_D)],M/sampling,T)*100+nu(1:sampling:end,:); % add noise to sub-sampled returns 
    RV_5_min=sum(r_D.^2)';  % construct RV at 5 minutes 
    freq=[1,5,22];  % frequencies for the HAR
    result1=HAR(log(RV_5_sec),[],freq,1); % estimates of the HAR on RV5 sec
    result2=HAR(log(RV_5_min),[],freq,1); % estimates of the HAR on RV5 min
    Omega=cov([result1.resid,result2.resid]); % variances of the errors
    beta_hat=[result1.beta;result2.beta;vechmd(Omega)]; % auxiliary estimates
    beta(:,j)=beta_hat; % auxilairy estimates at the j-th iteration
end;
    m_beta=mean(beta')'; % compute difference
    
